// config: norepeat

#include "GetObjects.js"
#include "GetLine.js"

function DoRotateAxis()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowEditPoints();

	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectsPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'FirstLinePrompt' );
	moi.ui.showUI( 'RotateOptions' );
	moi.ui.endUIUpdate();


	var axispoints = new Array();

	if ( !GetLine( axispoints ) )
		return;
	
	var axislinefactory = moi.command.createFactory( 'line' );
	axislinefactory.setInput( 0, axispoints[0] );
	axislinefactory.setInput( 1, axispoints[1] );
	axislinefactory.update();
			
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SecondLinePrompt' );
	moi.ui.showUI( 'FirstAnglePrompt' );
	moi.ui.showUI( 'AngleOptions' );
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'rotateaxis' );
	factory.setInput( 0, objects );
	factory.setInput( 1, axispoints[0] );
	factory.setInput( 2, axispoints[1] );

	var plane = null;
	try { plane = factory.plane; } catch(e) { return; }
	
	var pointpicker = moi.ui.createPointPicker();
	pointpicker.restrictToPlane( plane, true );
	pointpicker.disableVerticalStraightSnap = true;
	pointpicker.setBasePt( axispoints[0] );

	// First UI line - from start of axis to first reference point.
	var ref1linefactory = moi.command.createFactory( 'line' );
	ref1linefactory.setInput( 0, axispoints[0] );

	// Second UI line - from start of axis to second reference point.
	var ref2linefactory = moi.command.createFactory( 'line' );
	ref2linefactory.setInput( 0, axispoints[0] );

	var HaveBasePt = false;
	var basept;
	
	var KeepGoing = true;
	while ( KeepGoing )
	{
		KeepGoing = false;
		
		// Set up point picker bindings.
		pointpicker.clearBindings();
		
		if ( !HaveBasePt )
		{
			// If we're still waiting for the base point, hook it up to the first ref line.
			pointpicker.bindResultPt( ref1linefactory.getInput(1) );
		}
		else
		{
			// Otherwise, hook it up to the factory, set the UI binding and hook it up to the
			// second ref line.
			
			pointpicker.bindResultPt( factory.getInput(5) );
			pointpicker.setBasePt( axispoints[0] );

			moi.ui.commandUI.g_Factory = factory;
			pointpicker.bindFunc( moi.ui.commandUI.OnPoint );

			pointpicker.bindResultPt( ref2linefactory.getInput(1) );
		}
		
		while ( 1 )
		{
			if ( !pointpicker.waitForEvent() )
				return;

			var makecopy = moi.ui.commandUI.makecopies.value;
			var iscomplete = false;
			
			if ( pointpicker.event == 'angleinput' )
			{
				// When we get an angle input, we can either spit out a copy or be finished.
				factory.setInput( 3, moi.ui.commandUI.angleinput.value );
				iscomplete = true;
			}
			else if ( pointpicker.event == 'finished' )
			{
				if ( !HaveBasePt )
				{
					// This is the first reference point.
					HaveBasePt = true;

					basept = pointpicker.pt;

					factory.setInput( 4, pointpicker.pt );
			
					pointpicker.restrictToPlane( factory.plane, true );
					pointpicker.setRadialIntersection( factory.plane, basept );

					moi.ui.beginUIUpdate();
					moi.ui.hideUI( 'FirstAnglePrompt' );
					moi.ui.showUI( 'SecondAnglePrompt' );
					moi.ui.endUIUpdate();
		
					KeepGoing = true;
					break;
				}
				else
				{
					// If this is the second reference point, then we have enough to finish or create a copy.
				
					if ( pointpicker.controlDown )
						makecopy = true;
						
					if ( makecopy )
						moi.ui.removeLastPickedPoint();
						
					iscomplete = true;
				}
			}
			
			if ( iscomplete )
			{
				// We have enough info to either finish or to create a copy.
			
				if ( makecopy )
				{
					// Drop a copy and keep going.
					
					factory.reset();
					factory.setInput( 6, true );
					factory.update();
					factory.commit();
					
					// Set up a fresh factory to keep going.
					factory = moi.command.createFactory( 'rotateaxis' );
					factory.setInput( 0, objects );
					factory.setInput( 1, axispoints[0] );
					factory.setInput( 2, axispoints[1] );
					factory.setInput( 4, basept );
					factory.setInput( 5, pointpicker.pt );
					factory.update();
					
					KeepGoing = true;
				}
				
				break;
			}
		}
	}

	factory.update();	
	factory.commit();
}

DoRotateAxis();
